/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.entity;

import com.google.common.collect.Lists;
import com.ninni.spawn.SpawnTags;
import com.ninni.spawn.block.SnailEggsBlock;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnSoundEvents;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Snail
extends Animal {
    private static final EntityDataAccessor<Integer> SCARED_TICKS = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WET_TICKS = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHELL_GROWTH = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final UniformInt regrowthTicks = UniformInt.m_146622_((int)12000, (int)24000);
    private int cooldown = 2;

    public Snail(EntityType<? extends Snail> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(SpawnTags.SNAIL_FEEDS);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new SnailLayEggGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(SpawnTags.SNAIL_TEMPTS), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new SnailWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new SnailLookAtEntityGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new SnailLookAroundGoal(this));
    }

    public void m_27563_(ServerLevel world, Animal other) {
        if (other instanceof Snail) {
            Snail otherSnail = (Snail)other;
            ServerPlayer serverPlayerEntity = this.m_27592_();
            if (serverPlayerEntity == null) {
                serverPlayerEntity = otherSnail.m_27592_();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverPlayerEntity, (Animal)this, (Animal)otherSnail, null);
                CriteriaTriggers.f_10581_.m_147278_(serverPlayerEntity, (Animal)otherSnail, (Animal)this, null);
            }
            this.m_146762_(6000);
            otherSnail.m_146762_(6000);
            this.m_27594_();
            otherSnail.m_27594_();
            this.setHasEgg(true);
            otherSnail.setHasEgg(true);
            world.m_7605_((Entity)this, (byte)18);
            if (world.m_46469_().m_46207_(GameRules.f_46135_)) {
                world.m_7967_((Entity)new ExperienceOrb((Level)world, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(7) + 1));
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.1);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCARED_TICKS, (Object)0);
        this.f_19804_.m_135372_(WET_TICKS, (Object)0);
        this.f_19804_.m_135372_(SHELL_GROWTH, (Object)0);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("ScaredTicks", this.getScaredTicks());
        compoundTag.m_128405_("WetTicks", this.getWetTicks());
        compoundTag.m_128405_("Shelled", this.getShellGrowthTicks());
        compoundTag.m_128379_("HasEgg", this.hasEgg());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setScaredTicks(compoundTag.m_128451_("ScaredTicks"));
        this.setWetTicks(compoundTag.m_128451_("WetTicks"));
        this.setShellGrowthTicks(compoundTag.m_128451_("Shelled"));
        this.setHasEgg(compoundTag.m_128471_("HasEgg"));
    }

    public int getScaredTicks() {
        return (Integer)this.f_19804_.m_135370_(SCARED_TICKS);
    }

    public void setScaredTicks(int scaredTicks) {
        this.f_19804_.m_135381_(SCARED_TICKS, (Object)scaredTicks);
    }

    public boolean isScared() {
        return this.getScaredTicks() > 0;
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    public int getWetTicks() {
        return (Integer)this.f_19804_.m_135370_(WET_TICKS);
    }

    public void setWetTicks(int wetTicks) {
        this.f_19804_.m_135381_(WET_TICKS, (Object)wetTicks);
    }

    public void addWetTicks(int wetTicks) {
        this.setWetTicks(this.getWetTicks() + wetTicks);
    }

    public int getShellGrowthTicks() {
        return (Integer)this.f_19804_.m_135370_(SHELL_GROWTH);
    }

    public void setShellGrowthTicks(int shellTicks) {
        this.f_19804_.m_135381_(SHELL_GROWTH, (Object)shellTicks);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.m_6898_(itemStack) && this.m_146764_() == 0) {
            if (itemStack.m_150930_(Items.f_42400_)) {
                this.m_19998_((ItemLike)Items.f_42399_);
            }
            this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_EAT.get(), 1.0f, 1.0f);
        }
        if (itemStack.m_150930_(Items.f_42447_) && !this.isScared() && this.getWetTicks() < 900) {
            if (!this.m_9236_().f_46443_) {
                if (!player.m_150110_().f_35937_) {
                    player.m_21008_(player.m_7655_(), Items.f_42446_.m_7968_());
                }
                this.addWetTicks(300);
                this.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public void m_8107_() {
        int shellGrowthTicks;
        super.m_8107_();
        if (this.getWetTicks() > 0) {
            this.addWetTicks(-1);
            if (this.f_19796_.m_188503_(10) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123804_, this.m_20208_(0.6), this.m_20186_() + this.f_19796_.m_188500_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
            }
        }
        if (this.m_20075_().m_204336_(SpawnTags.MUCUS_SOLIDIFIER) || this.m_20070_()) {
            this.addWetTicks(1);
        }
        if (!this.m_9236_().f_46443_ && this.m_20096_() && this.getWetTicks() > 0) {
            BlockState blockState = ((Block)SpawnBlocks.MUCUS.get()).m_49966_();
            for (int l = 0; l < 4; ++l) {
                if (this.cooldown >= 0) continue;
                int i = Mth.m_14107_((double)(this.m_20185_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos blockPos2 = new BlockPos(i, Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)(this.m_20189_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (!this.m_9236_().m_8055_(blockPos2).m_60795_() || !blockState.m_60710_((LevelReader)this.m_9236_(), blockPos2)) continue;
                this.m_9236_().m_46597_(blockPos2, blockState);
                this.cooldown = 10;
                this.m_7355_(blockPos2, blockState);
                this.m_9236_().m_220407_(GameEvent.f_157797_, blockPos2, GameEvent.Context.m_223719_((Entity)this, (BlockState)blockState));
            }
            --this.cooldown;
        }
        this.m_9236_().m_6443_(Player.class, this.m_20191_().m_82400_(2.0), this::isValidEntity).forEach(player -> this.setScaredTicks(100));
        if (this.getScaredTicks() > 0) {
            this.m_21573_().m_26573_();
            this.setScaredTicks(this.getScaredTicks() - 1);
        }
        if (!this.m_9236_().m_5776_() && (shellGrowthTicks = this.getShellGrowthTicks()) > 0 && !this.m_6162_()) {
            if (shellGrowthTicks == 1) {
                this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_SHELL_GROW.get(), 1.0f, 1.0f);
            }
            this.setShellGrowthTicks(shellGrowthTicks - 1);
        }
    }

    private boolean isValidEntity(Player entity) {
        return this.getShellGrowthTicks() == 0 && !entity.m_5833_() && entity.m_6084_() && !entity.m_150110_().f_35937_ && !entity.m_6144_();
    }

    public boolean m_6094_() {
        return !this.isScared();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && this.getShellGrowthTicks() == 0) {
            if (source.m_269533_(DamageTypeTags.f_268524_)) {
                if (!this.isScared()) {
                    this.m_5552_(new ItemStack((ItemLike)SpawnItems.SNAIL_SHELL.get()), 0.1f);
                    this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_HURT_HIDDEN.get(), 1.0f, 1.0f);
                    this.setShellGrowthTicks(this.regrowthTicks.m_214085_(this.f_19796_));
                }
                return false;
            }
            this.setScaredTicks(100);
        }
        if (source.m_7639_() instanceof LivingEntity && amount < 12.0f && !this.m_9236_().f_46443_ && this.isScared()) {
            this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_HURT_HIDDEN.get(), 1.0f, 1.0f);
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_5829_() {
        return this.isScared();
    }

    public void m_7023_(Vec3 vec3) {
        if (this.isScared()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            vec3 = vec3.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(vec3);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return "Gary".equals(ChatFormatting.m_126649_((String)this.m_7755_().getString())) ? SoundEvents.f_11785_ : super.m_7515_();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SpawnSoundEvents.SNAIL_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return this.isScared() ? (SoundEvent)SpawnSoundEvents.SNAIL_DEATH_HIDDEN.get() : (SoundEvent)SpawnSoundEvents.SNAIL_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_SLIDE.get(), 0.15f, 1.0f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public static boolean canSpawn(EntityType<Snail> snailEntityEntityType, ServerLevelAccessor world, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        return world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && Animal.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public static class SnailLayEggGoal
    extends Goal {
        private final Snail snail;
        private BlockPos layPos;

        SnailLayEggGoal(Snail snail) {
            this.snail = snail;
        }

        public boolean m_8036_() {
            BlockPos layPos = this.getLayPosition();
            if (this.layPos == null && layPos != null) {
                this.layPos = layPos;
            }
            return this.layPos != null && this.snail.hasEgg();
        }

        public boolean m_8045_() {
            return this.layPos != null && this.snail.m_9236_().m_8055_(this.layPos).m_204336_(BlockTags.f_144274_) && this.snail.m_9236_().m_8055_(this.layPos.m_7494_()).m_60795_();
        }

        public void m_8056_() {
            if (this.layPos != null) {
                Vec3 vec3d = Vec3.m_82512_((Vec3i)this.layPos);
                this.snail.m_21573_().m_26519_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                this.snail.m_21563_().m_24964_(vec3d);
            }
        }

        public void m_8037_() {
            Vec3 vec3d;
            double distance;
            if (this.layPos != null && (distance = (double)Mth.m_14116_((float)((float)this.snail.m_20238_(vec3d = Vec3.m_82512_((Vec3i)this.layPos))))) <= 2.0) {
                this.snail.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_LAY_EGGS.get(), 1.0f, 1.0f);
                this.snail.m_9236_().m_7731_(this.layPos, (BlockState)((Block)SpawnBlocks.SNAIL_EGGS.get()).m_49966_().m_61124_((Property)SnailEggsBlock.m_153933_((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true)), 2);
                this.snail.setHasEgg(false);
            }
        }

        @Nullable
        private BlockPos getLayPosition() {
            ArrayList list = Lists.newArrayList();
            int range = 8;
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos position = new BlockPos((int)this.snail.m_20185_() + x, (int)this.snail.m_20186_(), (int)this.snail.m_20189_() + z);
                    if (!this.snail.m_9236_().m_8055_(position.m_7495_()).m_204336_(BlockTags.f_144274_) || !this.snail.m_9236_().m_8055_(position).m_60795_()) continue;
                    list.add(position);
                }
            }
            if (list.isEmpty()) {
                return null;
            }
            return (BlockPos)list.get(this.snail.f_19796_.m_188503_(list.size()));
        }
    }

    public static class SnailWanderGoal
    extends WaterAvoidingRandomStrollGoal {
        private final Snail mob;

        public SnailWanderGoal(Snail mob, double d) {
            super((PathfinderMob)mob, d);
            this.mob = mob;
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.isScared();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.mob.isScared();
        }
    }

    public static class SnailLookAtEntityGoal
    extends LookAtPlayerGoal {
        private final Snail mob;

        public SnailLookAtEntityGoal(Snail mob, Class<? extends LivingEntity> targetType, float range) {
            super((Mob)mob, targetType, range);
            this.mob = mob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.isScared();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.mob.isScared();
        }
    }

    public static class SnailLookAroundGoal
    extends RandomLookAroundGoal {
        private final Snail mob;

        public SnailLookAroundGoal(Snail mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.isScared();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.mob.isScared();
        }
    }
}

